<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class TournamentClan extends Model
{
    protected $fillable = [
        'tournament_id',
        'clan_id',
        'current_rank',
        'is_eliminated',
        'eliminated_at',
        'total_points',
        'total_wins',
        'prize',
    ];

    protected $casts = [
        'current_rank' => 'integer',
        'is_eliminated' => 'boolean',
        'eliminated_at' => 'datetime',
        'total_points' => 'integer',
        'total_wins' => 'integer',
        'prize' => 'integer',
    ];

    public function tournament(): BelongsTo
    {
        return $this->belongsTo(Tournament::class);
    }

    public function clan(): BelongsTo
    {
        return $this->belongsTo(Clan::class);
    }
}
