<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Tournament extends Model
{
    protected $fillable = [
        'name',
        'description',
        'registered_clans_count',
        'max_clans',
        'prize_pool',
        'starts_at',
        'ends_at',
        'is_active',
        'is_locked',
        'locked_at',
    ];

    protected $casts = [
        'registered_clans_count' => 'integer',
        'max_clans' => 'integer',
        'prize_pool' => 'integer',
        'starts_at' => 'datetime',
        'ends_at' => 'datetime',
        'is_active' => 'boolean',
        'is_locked' => 'boolean',
        'locked_at' => 'datetime',
    ];

    public function tournamentClans(): HasMany
    {
        return $this->hasMany(TournamentClan::class);
    }

    public function clans(): BelongsToMany
    {
        return $this->belongsToMany(Clan::class, 'tournament_clans');
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }
}
