<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureActiveForTournament
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = $request->user();

        if (!$user) {
            return $next($request);
        }

        if (!$user->is_active) {
            return back()->withErrors([
                'activation' => 'حسابك غير مُفعّل بعد. يمكنك تصفح الموقع، لكن لا يمكنك إنشاء أو الانضمام إلى كلان داخل قسم البطولات حتى يتم تفعيل حسابك من الإدارة.',
            ]);
        }

        return $next($request);
    }
}
